package elaborator.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import elaborator.utils.DataGenerator;

/**
 * generatore di pianeti, sensore virtuale;
 * 
 * @author koelio
 * @param newplanet
 *            viene assegnato un nome deault dal sensore
 */
public class TestDataGenerator extends DataGenerator {

	private int[] temps = new int[2];
	private int diameter;
	private String newplanet;
	private HashMap<Double, String> elements = new HashMap<Double, String>();

	public TestDataGenerator() {
		this.newplanet = "TestPlanet2";
		File file = new File("sensor/" + newplanet + ".txt");

		try {
			BufferedReader reader = new BufferedReader(new FileReader(file));

			String line = reader.readLine();

			StringTokenizer tok = new StringTokenizer(line);

			temps[0] = Integer.parseInt(tok.nextToken());

			temps[1] = Integer.parseInt(tok.nextToken());

			line = reader.readLine();
			StringTokenizer tok2 = new StringTokenizer(line);

			diameter = Integer.parseInt(tok2.nextToken());
			line = reader.readLine();

			while (line != null) {

				StringTokenizer tok3 = new StringTokenizer(line);
				// System.out.println(tok3.nextToken());
				elements.put(Double.parseDouble(tok3.nextToken()),
						tok3.nextToken());

				line = reader.readLine();
			}

			reader.close();

		} catch (FileNotFoundException e) {
			// Niente da fare: non ci aspettiamo di avere problemi con i file di
			// test
		} catch (IOException e) {
			// Niente da fare: non ci aspettiamo di avere problemi con i file di
			// test
		}

	}

	@Override
	public int[] getTemps() {
		return temps;
	}

	@Override
	public int getDiameter() {
		return diameter;
	}

	@Override
	public Map<Double, String> getComposition() {
		return elements;
	}

	@Override
	public String getPlanet() {

		return this.newplanet;
	}

}
